#pragma rtGlobals=1		// Use modern global access method.

Menu "Plot&Fit"
	submenu "Diffraction"
	"Diffraction Panel",DWS_DiffractionPnl()
	"Simple Tetragonal Hull-Davey", TetragonalHullDavey(.4,1.8,0)
	"Body-Centered Tetragonal Hull-Davey", TetragonalHullDavey(.4,1.8,1)
	"Hexagonal Hull-Davey", HexagonalHullDavey(.4,0.18)
	end
end

//http://cst-www.nrl.navy.mil/lattice/struk/index.html

Function DWS_DiffractionPnl()
		//IN2G_CheckScreenSize("height",670)
	DoWindow DWS_DiffManipulationPnl
	if(V_Flag)
		DoWindow/K DWS_DiffManipulationPnl
	endif
	IR1D_InitDataManipulation()
	IR2D_DWSPlotToolInit()

	variable/g root:Packages:SASDataModification:Peakmin=75,root:Packages:SASDataModification:box=3,root:Packages:SASDataModification:THshift=0
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	PlotDiffData("yavedata","xavedata", "")
	setAxis bottom .02, .1
	SetAxis/A left
	removefromgraph yavedata
	textBox/K/N=text0
end


Function PlotDiffData(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	dowindow/K DiffractionGraph
	Display/K=1/N=DiffractionGraph/W=(1*IN2G_ScreenWidthHeight("width"),1*IN2G_ScreenWidthHeight("heigth"),40*IN2G_ScreenWidthHeight("width"),60*IN2G_ScreenWidthHeight("height")) rwave vs qwave
	ControlBar /T 170
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="arial", fsize=18, fstyle=0, Title="Diffraction Tool",Labelback=0, POS={265,5},Size={200,20}
	variable YPOS=130
	Button PlotDiffData,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="PlotDATA"		
	Button GetArea,pos={60,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="Area"	
	Button avg,pos={120,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="avg csrs"	
	Button dSpacing,pos={180,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="d spacing"	
	Button Peaks,pos={240,YPOS},size={70,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="Find Peak"	
	SetVariable box, pos={315,YPOS}, size={60,20},title="box"
	SetVariable box, value= root:Packages:SASDataModification:box
	
	SetVariable peakmin, pos={380,YPOS}, size={100,20},title="Min Height"
	SetVariable peakmin, value= root:Packages:SASDataModification:Peakmin	
	YPOS=150
		
	Button RemoveDiffTrace,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc= DWS_DiffButtonProc,title="RemoveTrace"	
	Button LoadUDF,pos={65,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="Load .udf"		
	Button LoadASC,pos={130,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="Load .asc"		
	//Button Colors,pos={70,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="colors"		
	Button AcceptShifted,pos={390,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DiffButtonProc,title="Accept Shifted"			
	SetVariable TTHshift, pos={280,YPOS}, size={100,20},title="TTH Shift ",proc=DWS_DiffDataManip
	SetVariable TTHshift, limits={-inf,Inf,0.005},value= root:Packages:SASDataModification:THshift
	
	String PckgDataFolder="SASDataModification"
	String PanelWindowName="DiffractionGraph"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes=""//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes=""//"r*;"	
	String UserNameString="qrs"
	String XUserTypeLookup="r*:q*;"	
	String EUserTypeLookup="s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,  AllowModelData)
	MoveSelectionTools(2, 2)
end


Function DWS_DiffDataManip(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName,varStr,varName
	Variable varNum
	SVAR FolderName=root:Packages:SASDataModification:DataFolderName
	SVAR RWaveName=root:Packages:SASDataModification:IntensityWaveName
	SVAR QWaveName=root:Packages:SASDataModification:QWavename					
	NVAR THshift=root:Packages:SASDataModification:THshift
	string thefolder,thetext="",list,n,tracename
	variable counter = 0,NumberofWaves,background,start	
	setdatafolder foldername
	wave RWave=$Rwavename	
	wave QWave=$Qwavename	
	
	if(cmpstr(ctrlName,"TThshift")==0)
		duplicate/o qwave qwaveshifted
		Duplicate/o rwave,rwaveshifted
		qwaveshifted=qwave+THshift	
		RemoveFromGraph/z Rwaveshifted
		appendtograph rwaveshifted vs qwaveshifted	
		TextBox/K/N=FolderLegend	
		DWS_DiffButtonProc("colors")
	endif	
End

Function DWS_DiffButtonProc(ctrlName) : ButtonControl
	String ctrlName		
	SVAR FolderName=root:Packages:SASDataModification:DataFolderName
	SVAR RWaveName=root:Packages:SASDataModification:IntensityWaveName
	SVAR QWaveName=root:Packages:SASDataModification:QWavename					
	NVAR THshift=root:Packages:SASDataModification:THshift
	string thefolder,thetext="",list,n,tracename
	variable counter = 0,NumberofWaves,background,start
	string wavenote, cmd
	If(datafolderexists(foldername))
		setdatafolder foldername
		wave RWave=$Rwavename	
		wave QWave=$Qwavename	
	else
		setdatafolder root:	
	endif
	
	IF(cmpstr(ctrlName,"RemoveDiffTrace")==0)
		string tracelist=TraceNameList("DiffractionGraph", ";", 1 )
		 tracename=StringFromList(0, tracelist,";")
		If (!stringmatch(tracename, "" ))
			tracename=StringFromList(1, tracelist,";")
			RemoveFromGraph $tracename
		else
			Legend/K/N=text1
			string boxname="CF_"+Rwavename
			TextBox/K/N=$boxname
		endif
	endif	
	
	IF(cmpstr(ctrlName,"AcceptShifted")==0)//must choose target wave in dropdown
		//setdatafolder GetWavesDataFolder(Rwave, 1 )	
		wave Rwaveshifted
		wave qwaveshifted
		Rwave=Rwaveshifted
		qwave=qwaveshifted	
		RemoveFromGraph/z Rwaveshifted
		Killwaves Rwaveshifted,qwaveshifted
		Note Rwave, "TTH has been shifted by "+num2str(THshift)+""
		Note Qwave, "TTH has been shifted by "+num2str(THshift)+""
		TextBox/K/N=FolderLegend	
	endif
	
	IF(cmpstr(ctrlName,"avg")==0)
		Wave w = CsrWaveRef(A)	
		if (!WaveExists(w))
			Doalert 0, "Cursor is not on graph"
			abort
		endif			
		WaveStats/r=[pcsr(A),pcsr(B)]w
		setdatafolder root:Packages:SASDataModification
		make/o/N=2 xavedata,yavedata
		yavedata=V_avg
		 wave q = CsrXWaveRef(A  ,"DiffractionGraph")
		xavedata={ q(pcsr(A)), q[pcsr(B)]}
		appendtograph  yavedata vs xavedata
		ModifyGraph lsize(yavedata)=3,rgb(yavedata)=(0,0,0)
		string text= "average ="+num2str (background)	
		TextBox/C/N=text232/A=MT/X=2.00/Y=3.00 text		
	endif
	

	IF(cmpstr(ctrlName,"GetArea")==0)
		setdatafolder  FolderName
		variable AreaUnder
		wave q = CsrXWaveRef(A  ,"DiffractionGraph")
		wave r= CsrWaveRef(A  ,"DiffractionGraph")
		AreaUnder= areaXY(q, r, q[pcsr(a)],q[Pcsr(b)])
		string Text1="Area ="+num2str(areaunder)		
		variable bkgarea
		bkgarea= (q(pcsr(B))- q(pcsr(A)))*(r(pcsr(B))+ r(pcsr(A)))/2
		text1=text1+"\rbkgarea = "+num2str(bkgarea)		
		variable netarea=Areaunder-bkgarea
		text1=text1+"\rNet area = "+num2str(netarea)
		
		FindPeak  /Q/M=(.1)/B=(3) /R=(pcsr(A),pcsr(B))  r
		//variable peak=V_PeakLoc
		//Ipeak=V_PeakVal
		text1=text1+"\rWidth = "+num2str(V_PeakWidth)
		
		TextBox/C/N=text22/A=MC text1
	endif
	
	IF(cmpstr(ctrlName,"dSpacing")==0)
		setdatafolder  FolderName
		variable spacing,Ipeak
		wave angle = CsrXWaveRef(A  ,"DiffractionGraph")
		wave rwave = CsrWaveRef(A  ,"DiffractionGraph")
		string anglename=CsrXWave(A  ,"DiffractionGraph")
		spacing =  1.54/(2*sin(angle(pcsr(a))*pi/360))
		variable sinsqrdthetaB=(sin(angle(pcsr(a))*pi/360))^2
		Ipeak=rwave(pcsr(a))
		string Text2="\F'Symbol'q\M\F'arial'\BB\M = "+num2str(angle[pcsr(a)]/2)			
		text2=text2+"\rd= "+num2str(spacing)	+"  \rsin\S2\M(\F'Symbol'q\M\F'arial'\BB\M) = "+num2str( sinsqrdthetaB)	+"\rI = "+num2str(Ipeak) 
		 String tracen=FindCursorTrace()	
		string text3 ="T"+tracen[0,10]+num2str(pcsr(A))
		text3 =CleanupName(text3, 0 )
		Tag/C/N=$text3 $tracen, pcsr(A),text2
	endif
	
	IF(cmpstr(ctrlName,"peaks")==0)
		setdatafolder  FolderName
		 //String tracen1=FindCursorTrace()
		 NVAR peakmin=root:Packages:SASDataModification:Peakmin	
		 NVAR box=root:Packages:SASDataModification:box	
		 wave rwave = CsrWaveRef(A  ,"DiffractionGraph")
		FindPeak  /Q/M=(peakmin)/B=(box) /R=(pcsr(A),pcsr(B))  rwave
		variable peak=V_PeakLoc
		Ipeak=V_PeakVal
		wave anglewave = CsrXWaveRef(A  ,"DiffractionGraph")
		//wave angle = peak//CsrXWaveRef(A  ,"DiffractionGraph")
		 anglename=CsrXWave(A  ,"DiffractionGraph")
		spacing =  1.54/(2*sin(anglewave(peak)*pi/360))
		 sinsqrdthetaB=(sin(anglewave(peak)*pi/360))^2
		 Text2="\F'Symbol'q\M\F'arial'\BB\M = "+num2str(anglewave(peak)/2)			
		text2=text2+"\rd= "+num2str(spacing)	+"  \rsin\S2\M(\F'Symbol'q\M\F'arial'\BB\M) = "+num2str( sinsqrdthetaB)	+"\rI = "+num2str(Ipeak) 
		//text2=text2+"\rwidth = "+num2str(V_PeakWidth)
		 tracen=FindCursorTrace()	
		 text3 ="T"+tracen[0,10]+num2str(floor(peak))
		text3 =CleanupName(text3, 0 )
		Tag/C/N=$text3 $tracen, peak,text2
	endif
	
	IF(cmpstr(ctrlName,"LoadUDF")==0)
			loadUDF_Panalytical(2,0)	
	endif
	
	IF(cmpstr(ctrlName,"LoadASC")==0)
			load1d(1,2,4,-1,0,2,"",1)//(newfolder,qloadall,nm,nameline,headerlines,nocols,filetype)	
	endif
	
	IF(cmpstr(ctrlName,"Colors")==0)
			FormatGraph(1)
			Label left "\\F'arial'\\f01\\Z16Intensity "
			Label bottom "2\\F'Symbol'q \\F'arial'\\BB\M"
			TextBox/K/N=FolderLegend	
	endif
	
	IF(cmpstr(ctrlName,"PlotDiffData")==0)	
		setdatafolder  FolderName		
		Appendtograph RWave vs Qwave
		variable Npts=numpnts(Rwave)
		execute("cursor a,"+PossiblyQuoteName(RWaveName )+",0")
		execute("cursor b,"+PossiblyQuoteName(RWaveName )+",200")		
		Legend/C/N=text1
		Label bottom "2\\F'Symbol'q \\F'arial'\\BB\M"
	 	Label Left "\Z14\f01\F'arial'Intensity"
		ShowInfo
		DWS_DiffButtonProc("colors")
	endif
end

function hexagonalHullDavey(minR,maxR)
		variable minR,maxR
		variable h,k,l
		newdatafolder/o/s root:hexagonalHullDavey
		h=1;k=1;l=1
		make/o CoverA
		CoverA=1.4+p*.6/127		
		SetScale/I x 1.4,2,"", CoverA
		duplicate/o ,CoverA,w100,w002,w102,w101,w110,w103,w200,w112,w201,w004,w202,w104,w203,w210,w211,w114
		w100=hexagonald(covera,1,0,0)
		w002=hexagonald(covera,0,0,2)
		w101=hexagonald(covera,1,0,1)
		w102=hexagonald(covera,1,0,2)
		w110=hexagonald(covera,1,1,0)
		w103=hexagonald(covera,1,0,3)
		w200=hexagonald(covera,2,0,0)		
		w112=hexagonald(covera,1,1,2)	
		w201=hexagonald(covera,2,0,1)
		w004=hexagonald(covera,0,0,4)
	
		dowindow/k dspacing
			make/o /N=10 dspacing=1,xwave			
			zinc()
			wave dzinc
			xwave=dzinc
	
			SetScale/I x 1,10,"", dspacing 
			dowindow/k dspacingw
			display/K=1/N=dspacingw dspacing vs xwave
			
	
			appendtograph dspacing 
					
			ModifyGraph width=380,height=25
			ModifyGraph log(bottom)=1
			ModifyGraph fSize(bottom)=18
			ModifyGraph minor(bottom)=1
			ModifyGraph btLen(bottom)=20,btThick(bottom)=2,stLen(bottom)=10	
			ModifyGraph mode=3,marker=10,mrkThick=2.5,lsize=2,msize=4
			SetAxis bottom 1,10^.5		
		ModifyGraph mode(dspacing#1)=0	
			ModifyGraph lsize(dspacing#1)=0.53
			
			
		
		dowindow/k hexagonal	
			display/k=1/N=hexagonal /vert w100,w002,w102,w101,w110,w103,w200,w112,w201,w004
			SetAxis bottom 10,1
			ModifyGraph log(bottom)=1
			FormatGraph(1)
			Label left "\Z18\F'arial'c/a"
			Label bottom" 4/3*(h\S2\M+hk+k\S2\M)+l\S2\M/(c/a)"
			//Legend/C/N=text0/A=MC
			TextBox/K/N=FolderLegend
			ModifyGraph width=380,height=500
			ModifyGraph lsize=2			
			ModifyGraph minor(left)=1
			ModifyGraph axisEnab(left)={0,0.75}
			ShowTools/A
			ModifyGraph grid=2, mirror(left)=1
			Tag/C/N=text1/F=0  w100, 2,"\F'arial'100"
			Tag/C/N=text2/F=0  w002, 2,"\F'arial'002"
			Tag/C/N=text3 /F=0 w102, 2,"\F'arial'102"
			Tag/C/N=text4/F=0  w101, 2,"\F'arial'101"
			Tag/C/N=text5/F=0  w110, 1.7,"\F'arial'110"
			Tag/C/N=text6/F=0  w103, 2,"\F'arial'103"
			Tag/C/N=text7/F=0  w200, 2,"\F'arial'200"
			Tag/C/N=text8/F=0  w112, 1.9,"\F'arial'112"
			Tag/C/N=text9/F=0  w201, 1.95,"\F'arial'201"
			Tag/C/N=text10/F=0  w004, 1.45,"\F'arial'004"
end

function hexagonald(CoverA,h,k,l)
	variable CoverA,h,k,l
	variable out
	out=((4/3)*(h^2+h*k+k^2))+l^2/((covera)^2)
	return out
end
Function graphite()
	Variable c,a
	a=2.4613//Zn
	c=6.708//Zn
	Hexagonal(c, a)
	duplicate/o d,dgraphite
	duplicate/o dgraphite,ThetaB
	ThetaB=(180/pi)*asin(1.54/(2*dgraphite))
	killwaves d	
end

Function Zinc()
	Variable c,a
	a=2.665//Zn
	c=4.9470//Zn
	Hexagonal(c, a)
	duplicate/o d,dZinc
	killwaves d	
end

function Hexagonal(c, a)
	variable c,a
	If(!datafolderexists("root:hexagonalHullDavey"))
		newdatafolder root:hexagonalHullDavey
	endif
	setdatafolder root:hexagonalHullDavey
	
	make/o/n=10 d
	d[0]=hexagonal_d(c,a,1,0,0)
	d[1]=hexagonal_d(c,a,0,0,2)
	d[2]=hexagonal_d(c,a,1,0,1)
	d[3]=hexagonal_d(c,a,1,0,2)
	d[4]=hexagonal_d(c,a,1,1,0)
	d[5]=hexagonal_d(c,a,1,0,3)
	d[6]=hexagonal_d(c,a,2,0,0)
	d[7]=hexagonal_d(c,a,1,1,2)
	d[8]=hexagonal_d(c,a,2,0,1)
	d[9]=hexagonal_d(c,a,0,0,4)
end	



function Hexagonal_d(c,a h,k,l)//for zn
	variable h,k,l, a,c
	variable out	
	out=((4/3)*(h^2+h*k+k^2)/a^2)+l^2/(c^2)
	out=out^-.5	
	return out
end

function TetragonalHullDavey(minR,maxR,bct)
		variable minR,maxR,bct
		variable h,k,l
		newdatafolder/o/s root:TetragonalHullDavey
		h=1;k=1;l=1
		make/o CoverA
		CoverA=minR+p*(maxR-minR)/127
		SetScale/I x minR,maxR,"", CoverA
		duplicate/o ,CoverA,w111,w102,w110,w101,w002,w100,w001, w112,w200,W103,w211,w202,w004,w220, w213,w215,w321,w301
		//both
		w110=tetragonald(covera,1,1,0)
		w101=tetragonald(covera,1,0,1)
		w002=tetragonald(covera,0,0,2)
		//bct only
		w112=tetragonald(covera,1,1,2)
		w200=tetragonald(covera,2,0,0)
		w103=tetragonald(covera,1,0,3)
		w211=tetragonald(covera,2,1,1)
		w202=tetragonald(covera,2,0,2)
		w004=tetragonald(covera,0,0,4)
		w220=tetragonald(covera,2,2,0)
		w213=tetragonald(covera,2,1,3)
		w215=tetragonald(covera,2,1,5)
		w321=tetragonald(covera,3,2,1)	
		w301=tetragonald(covera,3,0,1)
		//st only
		w111=tetragonald(covera,1,1,1)
		w102=tetragonald(covera,1,0,2)
		w100=tetragonald(covera,1,0,0)
		w001=tetragonald(covera,0,0,1)	
		
		
		dowindow/k dspacing
		indium()
			//wave dindium//default spacing	
			string dwavename="dwhitetin"//	userpicks wave here	<<<<
			wave dwave=$dwavename
			
			duplicate/o dwave,unitywave
			//dspacing =1
			unitywave=1
			SetScale/I x 0.7,7,"" unitywave//determins decades in graph
			dowindow/k dspacingw
		display/K=1/N=dspacingw unitywave
		//	ControlBar /T 150
		AppendToGraph/VERT dwave vs unitywave
		ModifyGraph mode($dwavename )=3,marker($dwavename)=19,rgb($dwavename)=(0,0,0);DelayUpdate
		Tag/C/N=text2/F=0/X=20/L=0 $dwavename, 1,dwavename
			ModifyGraph width=380,height=25
			ModifyGraph log(bottom)=1
			ModifyGraph fSize(bottom)=18
			ModifyGraph minor(bottom)=1
			ModifyGraph btLen(bottom)=20,btThick(bottom)=2,stLen(bottom)=10	
			ModifyGraph mode(unitywave)=0,lsize(unitywave)=1
			SetAxis bottom .7,7
						
		dowindow/k Tetragonalw
			display/k=1/vert/N=Tetragonalw w110,w101,w002,   w111,w102,w100,w001,  W112,w200,w103,w211,w202,w004,w220, w213,w215,w321,w301
			SetAxis bottom 100,1
		
			ModifyGraph log(bottom)=1
			FormatGraph(1)
			Label left "\Z18\F'arial'c/a"
			Label bottom" (h\S2\M+k\S2\M)+l\S2\M/(c/a)\S2\M"
			Legend/C/N=text0/A=MC
			TextBox/K/N=FolderLegend
			ModifyGraph width=380,height=500
			ModifyGraph lsize=2			
			ModifyGraph minor(left)=1
			ModifyGraph axisEnab(left)={0,0.75}
			ShowTools/A
			ModifyGraph rgb(w211)=(65535,21845,0),rgb(w220)=(52428,1,41942)
		Tag/C/N=text1/F=0  w111, 2,"\F'arial'111"
			Tag/C/N=text2/F=0  w102, 1.3,"\F'arial'102"
			Tag/C/N=text3 /F=0 w110, 1.8,"\F'arial'110"
			Tag/C/N=text4/F=0  w101, 1.8,"\F'arial'101"
			Tag/C/N=text5/F=0  w002, .9,"\F'arial'002"

			Tag/C/N=text1/F=0  w111, 1.6,"\F'arial'111"
			Tag/C/N=text2/F=0  w102, 1.4,"\F'arial'102"
			Tag/C/N=text7/F=0  w100, 2,"\F'arial'100"
			Tag/C/N=text8/F=0  w001, 1.9,"\F'arial'001"				
			Tag/C/N=text11/F=0  w112, 1.7,"\F'arial'112"
			Tag/C/N=text12/F=0  w200, 1.25,"\F'arial'200"			
			Tag/C/N=text13/F=0  w202, .9,"\F'arial'202"
			Tag/C/N=text14/F=0  w004, 2,"\F'arial'004"
			Tag/C/N=text15/F=0  w220, 0.5,"\F'arial'220"
			Tag/C/N=text16/F=0  w213, 0.8,"\F'arial'213"
			Tag/C/N=text17/F=0  w215, 1.9,"\F'arial'215"
			Tag/C/N=text18/F=0  w321, 1.9,"\F'arial'321"
			Tag/C/N=text20/F=0  w103, 2,"\F'arial'103"
			Tag/C/N=text21/F=0  w211, 1.2,"\F'arial'211"
			Tag/C/N=text21/F=0  w301, .5,"\F'arial'301"
			
			
			Legend/K/N=text0
			ModifyGraph grid=2, mirror(left)=1
			If (bct==1)
				removefromgraph w111,w102,w100,w001
			endif
			if(bct==0)
				removefromgraph W112,w200,w103,w211,w202,w004,w220, w213,w215
			endif
end

function tetragonald(CoverA,h,k,l)	
	variable CoverA,h,k,l	
	variable out
	out=(h^2+k^2)+(l^2)/((covera)^2)
	return out
end

Function Indium()
	Variable c,a
	If(!datafolderexists("root:TetragonalHullDavey"))
		newdatafolder root:TetragonalHullDavey
	endif
	setdatafolder root:TetragonalHullDavey
	a=3.2517//indium  wrong in Cullity
	c=4.9459//indium
	Tetragonal(c, a)
	//wave dindium_rod=root:TetragonalHullDavey:dindiumrod//actual data  kill to get calculated indium	
	//d=dindium_rod
	duplicate/o d,dindium
	killwaves d	
end
	
function Tetragonal(c, a)
	variable c,a
	If(!datafolderexists("root:TetragonalHullDavey"))
		newdatafolder root:TetragonalHullDavey
	endif
	setdatafolder root:TetragonalHullDavey
	
	make/o/n=12 d
	
	d[0]=tetragonal_d(c,a,1,0,1)
	d[1]=tetragonal_d(c,a,0,0,2)
	d[2]=tetragonal_d(c,a,1,1,0)
	d[3]=tetragonal_d(c,a,1,1,2)
	d[4]=tetragonal_d(c,a,2,0,0)
	d[5]=tetragonal_d(c,a,1,0,3)
	d[6]=tetragonal_d(c,a,2,1,1)
	d[7]=tetragonal_d(c,a,2,0,2)
	d[8]=tetragonal_d(c,a,0,0,4)
	d[9]=tetragonal_d(c,a,2,2,0)
	d[10]=tetragonal_d(c,a,2,1,3)
	d[11]=tetragonal_d(c,a,3,0,1)
	d[12]=tetragonal_d(c,a,2,1,5)
	
end	

function tetragonal_d(c,a,h,k,l)
	variable h,k,l,a,c
	variable out	
	out=((h^2+k^2)/a^2)+((l^2)/(c^2))
	out=out^-.5	
	return out
end


